/*jslint node: true, nomen: true, unparam: true */
/*global jquery, $, _, define, Marionette, jqm, describe, it, expect, beforeEach, afterEach, spyOn */

'use strict';

// Jasmine Unit Testing Suite
define(["jquery", "backbone", "marionette", "jasminejquery"
	, 'applets/wound-care-applet/core/views/EducationView'],
	function ($, Backbone, Marionette, doNotRemove, EducationView) {

		// Test suite that includes all of the Jasmine unit tests
		describe("Education", function () {
			var view,
				viewEl,
				collection,
				model;


			beforeEach(function() {


				model = new Backbone.Model({link:['link'],
					education:{}
				});
				view = new EducationView({model:model});
				viewEl = view.render().$el;
			});
			afterEach(function() {
				viewEl.remove();
			});
			it('should have correct fields in the correct order', function() {
				var fields = viewEl.find('.wc-p-sm');
				expect(fields.get(0).innerHTML).toBe('Evaluated desire to learn:');
				expect(fields.get(1).innerHTML).toBe('Evaluated ability to comprehend:');
				expect(fields.get(2).innerHTML).toBe('Defined a pressure ulcer?');
				expect(fields.get(3).innerHTML).toBe('Explained risk factors?');
				expect(fields.get(4).innerHTML).toBe('Explained a routine skin inspection?');
				expect(fields.get(5).innerHTML).toBe('Discussed the importance of nutrition, hydration, mobility, position changes, pressure redistribution, and relief?');
				expect(fields.get(6).innerHTML).toBe('Explained the treatment plan?');
				expect(fields.get(7).innerHTML).toBe('Explained preventative skin care?');
				expect(fields.get(8).innerHTML).toBe('Explained ulcer management (if necessary)?');
				expect(fields.get(9).innerHTML).toBe('Provided printed education material?');
				expect(fields.get(10).innerHTML).toBe('Discussed the role of the Veteran and/or caregivers including active participation in prevention and discharge planning?');
				expect(fields.get(11).innerHTML).toBe('Documented response to education:');


			});
//			it('should not have any past selections', function() {
//				expect(viewEl.find('[name="pressureUlcer-patient"]:checked').val()).toBe(undefined);
//			});
//			describe('with past data', function() {
//				beforeEach(function() {
//					Portal.scrollableZoneHeight = jasmine.createSpy('zone height').andReturn('1000px');
//					model = new Backbone.Model({link:['link'],
//						education:{pressureUlcer:{patient:{value:'Yes','object-type':'SkinAssessmentResponseString','datetime':'2014-02-24T14:18:05.954-05:00'}}}
//					});
//					view = new Portal.WoundCareApplet.EducationView({model:model});
//
//					viewEl = view.render().$el;
//					view.onShow();
//
//				});
//				it('should have the item selected', function() {
//					expect(viewEl.find('[name="pressureUlcer-patient"]:checked')).toBe('Yes');
//				});
//			});



		});
	});